
#ifndef _ASYNC_H_ /* Guard against multiple inclusion */
#define _ASYNC_H_ 1

/* Enable stress-tests. */
/* #define SMALL_LIMITS 1 */

#include <sys/types.h>

#if __GNUC__ != 2
/* The __attribute__ keyword helps make gcc -Wall more useful, but
 * doesn't apply to other C compilers.  You don't need to worry about
 * what __attribute__ does (though if you are curious you can consult
 * the gcc info pages). */
#define __attribute__(x)
#endif /* __GNUC__ != 2 */

/* 1 + highest file descriptor number expected */
#define FD_MAX 64

/* The number of TCP connections we will use.  This can be no higher
 * than FD_MAX, but we reserve a few file descriptors because 0, 1,
 * and 2 are already in use as stdin, stdout, and stderr.  Moreover,
 * libc can make use of a few file descriptors for functions like
 * gethostbyname. */
#define NCON_MAX FD_MAX - 8

void fatal (const char *msg, ...)
     __attribute__ ((noreturn, format (printf, 1, 2)));
void make_async (int);

/* Malloc-like functions that don't fail. */
void *xrealloc (void *, size_t);
#define xmalloc(size) xrealloc (0, size)
#define xfree(ptr) xrealloc (ptr, 0)
#define bzero(ptr, size) memset (ptr, 0, size)

void cb_add (int, int, void (*fn)(void *), void *arg);
void cb_free (int, int);
void cb_check (void);

#endif /* !_ASYNC_H_ */
