
#ifndef ALIGN_H
#define ALIGN_H

#include "nucleotable.h"
#include "dictionary.h"


const double simpleMatrix[22][22] = {
  {   1, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -Infinity, -2},
  {-0.2,    1, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -Infinity, -2},
  {-0.2, -0.2,    1, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -Infinity, -2},
  {-0.2, -0.2, -0.2,    1, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -Infinity, -2},
  {-0.2, -0.2, -0.2, -0.2,    1, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -Infinity, -2},
  {-0.2, -0.2, -0.2, -0.2, -0.2,    1, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -Infinity, -2},
  {-0.2, -0.2, -0.2, -0.2, -0.2, -0.2,    1, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -Infinity, -2},
  {-0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2,    1, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -Infinity, -2},
  {-0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2,    1, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -Infinity, -2},
  {-0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2,    1, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -Infinity, -2},
  {-0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2,    1, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -Infinity, -2},
  {-0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2,    1, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -Infinity, -2},
  {-0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2,    1, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -Infinity, -2},
  {-0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2,    1, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -Infinity, -2},
  {-0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2,    1, -0.2, -0.2, -0.2, -0.2, -0.2, -Infinity, -2},
  {-0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2,    1, -0.2, -0.2, -0.2, -0.2, -Infinity, -2},
  {-0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2,    1, -0.2, -0.2, -0.2, -Infinity, -2},
  {-0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2,    1, -0.2, -0.2, -Infinity, -2},
  {-0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2,    1, -0.2, -Infinity, -2},
  {-0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2, -0.2,    1, -Infinity, -2},
  {-Infinity, -Infinity, -Infinity, -Infinity, -Infinity, -Infinity, -Infinity, -Infinity, -Infinity, -Infinity, -Infinity, -Infinity, -Infinity, -Infinity, -Infinity, -Infinity, -Infinity, -Infinity, -Infinity, -Infinity, -Infinity, -Infinity},
  {-2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -Infinity, -2}
};
  
const double pam40[22][22] = { 
  {  6, -6, -3, -3, -6, -3, -2, -1, -6, -4, -5, -6, -4, -7, -1,  0,  0,-12, -7, -2, -Inf, -15},
  { -6,  8, -5, -9, -7, -1, -8, -8, -1, -5, -8,  1, -3, -8, -3, -2, -5, -1, -9, -7, -Inf, -15},
  { -3, -5,  7,  2, -9, -3, -1, -2,  1, -4, -6,  0, -7, -8, -5,  0, -1, -7, -4, -7, -Inf, -15},
  { -3, -9,  2,  7,-12, -2,  3, -3, -3, -6,-11, -4, -9,-13, -7, -3, -4,-13,-10, -7, -Inf, -15},
  { -6, -7, -9,-12,  9,-12,-12, -8, -7, -5,-13,-12,-12,-11, -7, -2, -7,-14, -3, -5, -Inf, -15},
  { -3, -1, -3, -2,-12,  8,  2, -6,  1, -7, -4, -2, -3,-11, -2, -4, -5,-11,-10, -6, -Inf, -15},
  { -2, -8, -1,  3,-12,  2,  7, -3, -4, -5, -8, -4, -6,-12, -5, -4, -5,-15, -8, -6, -Inf, -15},
  { -1, -8, -2, -3, -8, -6, -3,  6, -8, -9, -9, -6, -7, -8, -5, -1, -5,-13,-12, -5, -Inf, -15},
  { -6, -1,  1, -3, -7,  1, -4, -8,  9, -8, -5, -5, -9, -5, -3, -5, -6, -6, -3, -6, -Inf, -15},
  { -4, -5, -4, -6, -5, -7, -5, -9, -8,  8, -1, -5,  0, -2, -7, -6, -2,-12, -5,  2, -Inf, -15},
  { -5, -8, -6,-11,-13, -4, -8, -9, -5, -1,  7, -7,  1, -2, -6, -7, -6, -5, -6, -2, -Inf, -15},
  { -6,  1,  0, -4,-12, -2, -4, -6, -5, -5, -7,  6, -1,-12, -6, -3, -2,-10, -8, -8, -Inf, -15},
  { -4, -3, -7, -9,-12, -3, -6, -7, -9,  0,  1, -1, 11, -3, -7, -5, -3,-11,-10, -1, -Inf, -15},
  { -7, -8, -8,-13,-11,-11,-12, -8, -5, -2, -2,-12, -3,  9, -9, -6, -8, -4,  2, -7, -Inf, -15},
  { -1, -3, -5, -7, -7, -2, -5, -5, -3, -7, -6, -6, -7, -9,  8, -1, -3,-12,-12, -5, -Inf, -15},
  {  0, -2,  0, -3, -2, -4, -4, -1, -5, -6, -7, -3, -5, -6, -1,  6,  1, -4, -6, -5, -Inf, -15},
  {  0, -5, -1, -4, -7, -5, -5, -5, -6, -2, -6, -2, -3, -8, -3,  1,  7,-11, -6, -2, -Inf, -15},
  {-12, -1, -7,-13,-14,-11,-15,-13, -6,-12, -5,-10,-11, -4,-12, -4,-11, 13, -4,-14, -Inf, -15},
  { -7, -9, -4,-10, -3,-10, -8,-12, -3, -5, -6, -8,-10,  2,-12, -6, -6, -4, 10, -6, -Inf, -15},
  { -2, -7, -7, -7, -5, -6, -6, -5, -6,  2, -2, -8, -1, -7, -5, -5, -2,-14, -6,  7, -Inf, -15},
  {-Inf,-Inf,-Inf,-Inf,-Inf,-Inf,-Inf,-Inf,-Inf,-Inf,-Inf,-Inf,-Inf,-Inf,-Inf,-Inf,-Inf,-Inf,-Inf,-Inf,-Inf,-Inf}, 
  {-15 -15 -15 -15 -15 -15 -15 -15 -15 -15 -15 -15 -15 -15 -15 -15 -15 -15 -15 -15, -Inf, -Inf}
};

extern double **currAlignPAM;

void outputPam(double **pamMat);

void readPamMatrix(double **pamMat, ifstream &fin);

void readCodonMatrix(double ***codonMat, ifstream &fin);

void normalizePam(double, double**);

int breakptFind(int *htuples, int *hidx, int *himage, int hl,
		int *mtuples, int *midx, int *mimage, int ml, int tl,
		int *hbreaks, int *mbreaks);
// Returns: break count;

int constrainedAlign(FilterSequence *hseq, FilterSequence *mseq,
		     int *hbreaks, int *mbreaks, int breakCnt, int tupleLength,
		     double match, double mismatch, double gap, 
		     int *himage, int *mimage);

int constrainedAlign(FilterSequence *hseq, FilterSequence *mseq,
		     int *hbreaks, int *mbreaks, int breakCnt, int tupleLength,
		     double match, double mismatch, double gap, 
		     int *himage, int *mimage, int extnLength, int extnCutoff);


int exactMatchFind(FilterSequence *hseq, FilterSequence *mseq, int tlength,
		   int *htuples, int *hidx, int &hl,
		   int *mtuples, int *midx, int &ml);
int exactLongMatchFind(FilterSequence *hseq, FilterSequence *mseq, int tlength,
		       int *htuples, int *hidx, int &hl,
		       int *mtuples, int *midx, int &ml);
// tlength:       tuple length;
// htuples, hidx: allocated arrays of length hseq->length;
// mtuples, midx: allocated arrays of length mseq->length;
// Finds all tlength-long matches between hseq and mseq, and records their;
//   tuple-indices in arrays htuples, mtuples, and their positions in the;
//   sequences in arrays hidx, midx. The number of tuples that match are;
//   recorded in hl, ml;

double findmap(int *seq1, int *seq2, int lengthfirst, int lengthsecond, double match, 
	     double mismatch, double gap, int *imagefirst, int *imagesecond, 
	     double *col1, double *col2, double *prebest, double *suffbest);

double findmapUseExtensions(int *seq1, int *seq2, int from1, int to1, int from2, int to2,  
			    double match, double mismatch, double gap, int *imagefirst, 
			    int *imagesecond, double *col1, double *col2, double *prebest, double *suffbest,
			    int *hseqInt, int *mseqInt, int *hptrs, int *mptrs, int hseql, int mseql, int extnLength, int tupLength);
// findmap is a recursive routine to find alignments in linear space.

void constraintsalign(int *first, int *second, int length1, int length2, 
		      double match, double mismatch, double gap, int *imagefirst, 
		      int *imagesecond, int *constraints1, int *constraints2, 
		      int constraintslength, int acceptNegativeAlignments);
// constraintsalign performs an alignment subject to a partial given map.

// The functions memalign and align perform the exact same task on the same 
// inputs. memalign does an alignment in linear space with more time than align, 
// which uses quadratic space.

double memalign(int *first, int *second, int fromfirst, int tofirst, int fromsecond, 
	      int tosecond, double match, double mismatch, double gap, 
	      int *imagefirst, int *imagesecond);

double memalignUseExtensions(int *first, int *second, int fromfirst, int tofirst, int fromsecond, 
			     int tosecond, double match, double mismatch, double gap, 
			     int *imagefirst, int *imagesecond, int *hseqInt, int *mseqInt,
			     int *hptrs, int *mptrs, int hseql, int mseql, int extnLength, int tupLength);

double align(int *first, int *second, int fromfirst, int tofirst, int fromsecond, 
	     int tosecond, double match, double mismatch, double gap, 
	     int *imagefirst, int *imagesecond);

double gappedAlign(int *first, int *second, int fromfirst, int tofirst, int fromsecond, 
		   int tosecond, double match, double mismatch, double gapOpen, double gap,
		   int *imagefirst, int *imagesecond);

int phaseAlign(FilterSequence *hseq, FilterSequence *mseq,
	       int phaseCount, int *tupLengths, int *humImg, int *mouseImg);
int phaseAlign(FilterSequence *hseq, FilterSequence *mseq, int *hseqInt, int *mseqInt,
	       int phaseCount, int *tupLengths, int *extnLengths, int *extnCutoffs,
	       int *humImg, int *mouseImg, char *inval_hum_pos, char *invalid_mus_pos, int repmask_cff);

double tupleAlignmentScore(int *htup, int *mtup, int hfrom, int hto, int mfrom, int mto,
			   double match, double mismatch, double gap, double alpha, double beta,
			   int *himg, int *mimg);

double exonAlignmentScore(FilterSequence *hseq, FilterSequence *mseq, int hfrom, int hto, int mfrom, int mto,
			  double match, double mismatch, double gap, double alpha, double beta, int cap,
			  int *himg, int *mimg, int isATG);

void constraintsalignUseExtensions(int *first, int *second, int length1, int length2, 
				   double match, double mismatch, double gap, int *imagefirst, 
				   int *imagesecond, int *constraints1, int *constraints2, 
				   int constraintslength, int acceptNegativeAlignments,
				   int *hseqInt, int *mseqInt, int *hptrs, int *mptrs,
				   int hseql, int mseql, int extnLength, int tupLength);


int extractAligningRegions(int *hseqInt, int *mseqInt, int *himg, int *mimg, int hseql, int mseql,
			   int maxgap, int minreglen,
			   int *hbegins, int *hends, int *mbegins, int *mends);


void outputAlignment(ofstream &fout, FilterSequence *hseq, FilterSequence *mseq, int *himg, int *mimg);
void outputAlignment(ofstream &fout, int *hseq, int *mseq, int *himg, int *mimg, int hseql, int mseql);

int theexonImagesToTry(FilterSequence *hseq, FilterSequence *mseq, int hstart, int hstop, int *himg, int *mimg,
		    int *mstarts, int *mstops);

double findmapPAM(int *seq1, int *seq2, int from1, int to1, int from2, int to2,  
		  int matrixIdx, int *imagefirst, int *imagesecond, double *col1, double *col2, double *prebest, 
		  double *suffbest);

double memalignPAM(int *first, int *second, int fromfirst, int tofirst, int fromsecond, 
		   int tosecond, int matrixIdx, int *imagefirst, int *imagesecond);


void alignExonPair(FilterSequence *hseq, FilterSequence *mseq, int hstart, int hstop, int mstart, int mstop,
		   int hfr, int mfr, int *himg, int *mimg,
		   char *haa, char *maa, int &haastart, int &maastart, int &haastop, int &maastop, int *haaimg, int *maaimg);

#endif

